@extends('user')
@section('content')
    @include('partials.breadcrumb')

    <div class="gateways-container pt-5">
        <div class="container">
            <div class="row">
                <div class="col-md-12 p-2">
                    @include('errors.alert')
                    @include('errors.error')
                </div>
            </div>


            <div class="row">
                @foreach($gates  as $gate)
                <div class="col-md-3">
                    <div class="card mb-5">
                        <div style="padding:5px;">
                            <img class="card-img-top" src="{{asset('assets/images/gateway')}}/{{$gate->id.'.jpg'}}" alt="{{$gate->name}}">
                        </div>
                        <div class="card-body">
                            <h5 class="card-title text-center">{{$gate->name}}</h5>
                        </div>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item text-center"><strong>@lang('LIMIT'): </strong>({{ $gate->minamo }} - {{$gate->maxamo }}) {{$basic->currency}}</li>
                            <li class="list-group-item text-center"><strong>@lang('Charge'): </strong> {{ $gate->fixed_charge }} {{$basic->currency}} + {{$gate->percent_charge }}%</li>
                        </ul>
                        <div class="card-footer">
                            <button class="btn btn-block btn-info" style="width: 100%" type="button" name="button" data-toggle="modal" data-target="#depositModal{{$gate->id}}">@lang('Deposit Now')</button>
                        </div>
                    </div>
                </div>
                <!-- Deposit Amount Modal -->
                <div class="modal fade" id="depositModal{{$gate->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" style="display: none;">
                    <div class="modal-dialog " role="document">
                        <form class="modal-content" method="post" action="{{route('deposit.data-insert')}}">
                            @csrf
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">@lang('Deposit via'){{__($gate->name)}}</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">×</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <div class="form-group">
                                    <label><strong>@lang('Amount')</strong></label>
                                    <div class="input-group mb-3">
                                        <input name="amount" type="text" class="form-control" placeholder="@lang('Enter Amount')" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" required="">
                                        <div class="input-group-append">
                                            <span class="input-group-text">{{__($basic->currency)}}</span>
                                        </div>
                                    </div>
                                </div>
                                <input type="hidden" name="gateway" value="{{$gate->id}}">


                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">@lang('Preview')</button>
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">@lang('Close')</button>
                            </div>
                        </form>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>




@stop
